// tWaveTestDlg.h : header file

#include "tWave.h"
#include "tDialString.h"

/////////////////////////////////////////////////////////////////////////////
// CTWaveTestDlg dialog

class CTWaveTestDlg : public CDialog,
                      private CtWaveSink,
                      private CtDialStringSink
{
// Construction
public:
	CTWaveTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CTWaveTestDlg)
	enum { IDD = IDD_TWAVETEST_DIALOG };
	CButton	m_btnStop;
	CButton	m_btnRecord;
	CButton	m_btnPlay;
	CString	m_sFileName;
	CString	m_sDialString;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTWaveTestDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON           m_hIcon;
    CtWave          m_wav;
    CtDialString    m_dtmf;

	// Generated message map functions
	//{{AFX_MSG(CTWaveTestDlg)
	afx_msg void OnBrowse();
	afx_msg void OnPlay();
	afx_msg void OnClose();
	afx_msg void OnRecord();
	afx_msg void OnStop();
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPlayDtmf();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    // CtWaveSink events
    virtual void OnWaveOutDone();
    virtual void OnWaveInData();

    // CtDialStringSink events
    virtual void OnDialDone();
    virtual void OnDialError();
};
