// tWaveTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "tWaveTest.h"
#include "tWaveTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTWaveTestDlg dialog

#pragma warning(disable:4355)   // 'this' : used in base member initializer list

CTWaveTestDlg::CTWaveTestDlg(CWnd* pParent /*=NULL*/)
	:
    CDialog(CTWaveTestDlg::IDD, pParent),
    m_wav(this),
    m_dtmf(this)
{
	//{{AFX_DATA_INIT(CTWaveTestDlg)
	m_sFileName = _T("");
	//}}AFX_DATA_INIT
	m_sDialString = _T("123A456B789C*0#D");
}

void CTWaveTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTWaveTestDlg)
	DDX_Control(pDX, IDC_STOP, m_btnStop);
	DDX_Control(pDX, IDC_RECORD, m_btnRecord);
	DDX_Control(pDX, IDC_PLAY, m_btnPlay);
	DDX_Text(pDX, IDC_FILE, m_sFileName);
	DDX_Text(pDX, IDC_DTMF, m_sDialString);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTWaveTestDlg, CDialog)
	//{{AFX_MSG_MAP(CTWaveTestDlg)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_CLOSE, OnClose)
	ON_BN_CLICKED(IDC_RECORD, OnRecord)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_WM_SYSCOMMAND()
	ON_BN_CLICKED(IDC_PLAY_DTMF, OnPlayDtmf)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTWaveTestDlg message handlers

void CTWaveTestDlg::OnBrowse() 
{
    char*   pszFilter = "Wave Files (*.wav)|*.wav|All Files (*.*)|*.*||";
	CFileDialog dlg(TRUE, "wav", 0, OFN_FILEMUSTEXIST, pszFilter, this);
	
    if( dlg.DoModal() == IDOK )
    {
        m_sFileName = dlg.GetPathName();
        m_wav.Load(m_sFileName);
        UpdateData(FALSE);
        m_btnPlay.EnableWindow(TRUE);
    }
}

void CTWaveTestDlg::OnPlay() 
{
    if( m_wav.Play(WAVE_MAPPER) )
    {
        m_btnPlay.EnableWindow(FALSE);
        m_btnRecord.EnableWindow(FALSE);
        m_btnStop.EnableWindow(TRUE);
    }
}

void CTWaveTestDlg::OnWaveOutDone()
{
    m_btnPlay.EnableWindow(TRUE);
    m_btnPlay.SetFocus();
    m_btnRecord.EnableWindow(TRUE);
    m_btnStop.EnableWindow(FALSE);
}

void CTWaveTestDlg::OnDialError()
{
    m_btnPlay.EnableWindow(TRUE);
    m_btnPlay.SetFocus();
    m_btnRecord.EnableWindow(TRUE);
    m_btnStop.EnableWindow(FALSE);
    MessageBox("Error playing DTMF Tones");
}

void CTWaveTestDlg::OnClose() 
{
    m_dtmf.Cancel();
    m_wav.Close();
    m_sFileName.Empty();
    UpdateData(FALSE);

    m_btnPlay.EnableWindow(FALSE);
    m_btnRecord.EnableWindow(TRUE);
    m_btnStop.EnableWindow(FALSE);
}

void CTWaveTestDlg::OnRecord() 
{
    const UINT  nMaxSecs = 30;

    if( m_wav.Record(WAVE_MAPPER, nMaxSecs) )
    {
        m_btnPlay.EnableWindow(FALSE);
        m_btnRecord.EnableWindow(FALSE);
        m_btnStop.EnableWindow(TRUE);

        CString sMsg;
        sMsg.Format("Recording up to %lu seconds...", nMaxSecs);
        SetDlgItemText(IDC_FILE, sMsg);
    }
}

void CTWaveTestDlg::OnWaveInData()
{
    // Pick a random path name
    char    szPath[MAX_PATH+1];
    GetTempPath(MAX_PATH, szPath);
	GetTempFileName(szPath, "wav", 0, m_sFileName.GetBuffer(MAX_PATH));
    m_sFileName.ReleaseBuffer();
    UpdateData(FALSE);

    // Save the file
    m_wav.Save(m_sFileName);

    // Enable the play/record buttons
    m_btnPlay.EnableWindow(TRUE);
    m_btnRecord.EnableWindow(TRUE);
    m_btnRecord.SetFocus();
    m_btnStop.EnableWindow(FALSE);
}

// CtDialStringSink events
void CTWaveTestDlg::OnDialDone()
{
    m_btnPlay.EnableWindow(TRUE);
    m_btnPlay.SetFocus();
    m_btnRecord.EnableWindow(TRUE);
    m_btnStop.EnableWindow(FALSE);
}

void CTWaveTestDlg::OnStop() 
{
	m_wav.Stop();
    m_dtmf.Cancel();
}

BOOL CTWaveTestDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Add "Play Resource..." menu item to system menu.

	// IDM_PLAY_RESOURCE must be in the system command range.
	ASSERT((IDM_PLAY_RESOURCE & 0xFFF0) == IDM_PLAY_RESOURCE);
	ASSERT(IDM_PLAY_RESOURCE < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString s;
	s.LoadString(IDS_PLAY_RESOURCE);
	if (!s.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_PLAY_RESOURCE, s);
	}

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTWaveTestDlg::OnSysCommand(UINT nID, LPARAM lParam) 
{
	if( (nID & 0xFFF0) == IDM_PLAY_RESOURCE )
	{
        if( m_wav.Load(AfxGetResourceHandle(), IDR_TEST_WAVE) )
        {
            OnPlay();
        }
	}
	else if( (nID & 0xFFF0) == IDM_PLAY_DTMF )
	{
        OnPlayDtmf();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CTWaveTestDlg::OnPlayDtmf() 
{
    UpdateData(TRUE);
    m_dtmf = m_sDialString;
    
    if( m_dtmf.Dial(WAVE_MAPPER, 500, 1000) )
    {
        m_btnPlay.EnableWindow(FALSE);
        m_btnRecord.EnableWindow(FALSE);
        m_btnStop.EnableWindow(TRUE);
    }
}
