// tPhoneTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "tPhoneTest.h"
#include "tPhoneTestDlg.h"
#include <tPhoneNo.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTPhoneTestDlg dialog

CTPhoneTestDlg::CTPhoneTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTPhoneTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTPhoneTestDlg)
	m_sCountryCode = _T("");
	m_sAreaCode = _T("");
	m_sPhoneNo = _T("");
	m_bCanonical = TRUE;
	m_sCanonical = _T("");
	m_sDisplayable = _T("");
	m_sTranslatable = _T("");
	m_bConvert = TRUE;
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTPhoneTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTPhoneTestDlg)
	DDX_Text(pDX, IDC_COUNTRY_CODE, m_sCountryCode);
	DDX_Text(pDX, IDC_AREA_CODE, m_sAreaCode);
	DDX_Text(pDX, IDC_PHONE_NO, m_sPhoneNo);
	DDX_Check(pDX, IDC_USE_AC_CC, m_bCanonical);
	DDX_Text(pDX, IDC_CANONICAL, m_sCanonical);
	DDX_Text(pDX, IDC_DISPLAYABLE, m_sDisplayable);
	DDX_Text(pDX, IDC_TRANSLATABLE, m_sTranslatable);
	DDX_Check(pDX, IDC_CONVERT, m_bConvert);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTPhoneTestDlg, CDialog)
	//{{AFX_MSG_MAP(CTPhoneTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_AREA_CODE, OnChangeInfo)
	ON_EN_CHANGE(IDC_COUNTRY_CODE, OnChangeInfo)
	ON_EN_CHANGE(IDC_PHONE_NO, OnChangeInfo)
	ON_BN_CLICKED(IDC_USE_AC_CC, OnChangeInfo)
	ON_BN_CLICKED(IDC_CONVERT, OnChangeInfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTPhoneTestDlg message handlers

BOOL CTPhoneTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTPhoneTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTPhoneTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CTPhoneTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTPhoneTestDlg::OnChangeInfo() 
{
	if( UpdateData(TRUE) )
    {
        GetDlgItem(IDC_AREA_CODE)->EnableWindow(m_bCanonical);
        GetDlgItem(IDC_COUNTRY_CODE)->EnableWindow(m_bCanonical);

        CtPhoneNo   pno;
        if( m_bCanonical )
        {
            pno.SetCountryCode(m_sCountryCode);
            pno.SetAreaCode(m_sAreaCode);
            pno.SetPhoneNo(m_sPhoneNo);
        }
        else
        {
            pno.SetWholePhoneNo(m_sPhoneNo);
        }

        m_sCanonical = pno.GetCanonical();
        m_sDisplayable = pno.GetDisplayable();

        if( m_bConvert )
        {
            m_sTranslatable = pno.GetTranslatable();
        }
        else
        {
            m_sTranslatable = pno.GetTranslatable(0);
        }

        UpdateData(FALSE);
    }
}
