// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tVarData.h: CtVariableData class interface

#ifndef TVARDATA_H
#define TVARDATA_H

#include <assert.h>
#include "TfxShared.h"

class CtVariableData
{
public:
    CtVariableData();
    virtual ~CtVariableData();

protected:
    struct VARDATA
    {
        DWORD   dwTotalSize;
        DWORD   dwNeededSize;
        DWORD   dwUsedSize;
    };

    VARDATA*    m_pd;

    TRESULT UpdateData();
    LPCSTR  GetStringPtr(DWORD nOffset, DWORD nSize,
                         DWORD dwStringFormat = STRINGFORMAT_ASCII) const;
    void*   GetDataPtr(DWORD nOffset) const;

    // Must be implemented by derived class!
    virtual TRESULT FillBuffer() =0;
};

// Inline member functions: For Compiler Eyes Only!

inline
CtVariableData::CtVariableData() : m_pd(0)
{
}

inline
CtVariableData::~CtVariableData()
{
    ::free(m_pd);
}

inline
LPCSTR CtVariableData::GetStringPtr(
    DWORD   nOffset,
    DWORD   nSize,
    DWORD   dwStringFormat) const // = STRINGFORMAT_ASCII
{
    if( dwStringFormat == STRINGFORMAT_ASCII )
    {
        if( nSize )
        {
            return LPCSTR(GetDataPtr(nOffset));
        }
        else
        {
            return "";
        }
    }
    else
    {
        // Only supporting ASCII strings
        return 0;
    }
}

inline
void* CtVariableData::GetDataPtr(
    DWORD   nOffset) const
{
    assert(m_pd);
    return LPVOID((BYTE*)m_pd + nOffset);
}

#endif  // TVARDATA_H
