// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tTranslateOutput.h: CtTranslateOutput class interface

#ifndef TTRANSLATEOUTPUT_H
#define TTRANSLATEOUTPUT_H

#include "tVarData.h"

class CtTranslateOutput : public CtVariableData
{
public:
    operator const LPLINETRANSLATEOUTPUT() const;

    TRESULT TranslateAddress(DWORD nLineID, LPCSTR pszAddressIn,
                             DWORD nCardID = 0, DWORD dwTranslateOptions = 0);

    LPCSTR  GetDialableString() const;
    LPCSTR  GetDisplayableString() const;
    DWORD   GetCurrentCountry() const;
    DWORD   GetDestCountry() const;
    DWORD   GetTranslateResults() const;

protected:
    virtual TRESULT FillBuffer();

private:
    DWORD   m_nLineID;
    LPCSTR  m_pszAddressIn;
    DWORD   m_nAddressID;
    DWORD   m_nCardID;
    DWORD   m_dwTranslateOptions;

    const LPLINETRANSLATEOUTPUT GetData() const;
};

// Inline member functions: For Compiler Eyes Only!

inline
CtTranslateOutput::operator const LPLINETRANSLATEOUTPUT() const
{
    return LPLINETRANSLATEOUTPUT(m_pd);
}

inline
const LPLINETRANSLATEOUTPUT CtTranslateOutput::GetData() const
{
    assert(m_pd);
    return LPLINETRANSLATEOUTPUT(m_pd);
}

inline
TRESULT CtTranslateOutput::TranslateAddress(
    DWORD   nLineID,
    LPCSTR  pszAddressIn,
    DWORD   nCardID,            // = 0
    DWORD   dwTranslateOptions) // = 0
{
    assert(CtLine::GetAppHandle());
    assert(nLineID < CtLine::GetNumDevs());
    assert(pszAddressIn && *pszAddressIn);

    m_nLineID = nLineID;
    m_pszAddressIn = pszAddressIn;
    m_nCardID = nCardID;
    m_dwTranslateOptions = dwTranslateOptions;

    return UpdateData();
}

inline
TRESULT CtTranslateOutput::FillBuffer()
{
    assert(m_pd->dwTotalSize >= sizeof(LINETRANSLATEOUTPUT));
    return ::TfxTapiFunc(::lineTranslateAddress(CtLine::GetAppHandle(),
                                                m_nLineID,
                                                CtLine::GetApiVersion(m_nLineID),
                                                m_pszAddressIn, m_nCardID,
                                                m_dwTranslateOptions,
                                                LPLINETRANSLATEOUTPUT(m_pd)),
                         TDBSTR("lineTranslateAddress"));
}

inline
LPCSTR CtTranslateOutput::GetDialableString() const
{
    return GetStringPtr(GetData()->dwDialableStringOffset,
                        GetData()->dwDialableStringSize);
}

inline
LPCSTR CtTranslateOutput::GetDisplayableString() const
{
    return GetStringPtr(GetData()->dwDisplayableStringOffset,
                        GetData()->dwDisplayableStringSize);
}

inline
DWORD CtTranslateOutput::GetCurrentCountry() const
{
    return GetData()->dwCurrentCountry;
}

inline
DWORD CtTranslateOutput::GetDestCountry() const
{
    return GetData()->dwDestCountry;
}

inline
DWORD CtTranslateOutput::GetTranslateResults() const
{
    return GetData()->dwTranslateResults;
}

#endif  // TTRANSLATEOUTPUT_H
