// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tRequestList.h: CtRequestList class interface

#ifndef TREQUESTLIST_H
#define TREQUESTLIST_H

#include "TfxShared.h"
#include "tRepTarg.h"
#include "TFXSTL.h"

class CtRequestList
{
public:
    ~CtRequestList();

    void    AddRequest(TREQUEST nRequestID, CtReplyTarget* pTarget,
                       DWORD nRequestType);

    BOOL    IsRequestPending(TREQUEST nRequestID = 0,
                             DWORD* pnRequestType = 0) const;

    BOOL    IsRequestTypePending(DWORD nRequestType,
                                 const CtReplyTarget* pTarget = 0) const;

    BOOL    RemoveRequest(TREQUEST nRequestID,
                          CtReplyTarget** ppTarget = 0,
                          DWORD* pnRequestType = 0);

    void    RemoveAllRequests(CtReplyTarget* pTarget = 0);

private:
    struct AsyncRequest
    {
        TREQUEST        nID;
        CtReplyTarget*  pTarget;
        DWORD           nType;

        AsyncRequest(TREQUEST _nID, CtReplyTarget* _pTarget, DWORD _nType)
            : nID(_nID), pTarget(_pTarget), nType(_nType) {}
    };

    CPointerList    m_listRequests;

    BOOL    FindRequest( TREQUEST nRequestID, AsyncRequest** ppar = 0 ) const;

};

#endif  // TREQUESTLIST_H
