// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tRequestList.cpp: CtRequestList class implementation

#include "stdafx.h"
#include "tRequestList.h"
#include "tRepTarg.h"

CtRequestList::~CtRequestList()
{
    RemoveAllRequests();
}

void CtRequestList::AddRequest(
    TREQUEST        nRequestID,
    CtReplyTarget*  pTarget,
    DWORD           nRequestType)
{
    m_listRequests.push_back(new AsyncRequest(nRequestID, pTarget, nRequestType));  //.AddTail(new AsyncRequest(nRequestID, pTarget, nRequestType));
}

BOOL CtRequestList::IsRequestPending(
    TREQUEST    nRequestID,           // = 0
    DWORD*      pnRequestType) const  // = 0
{
    // Are we looking for a specific request?
    if( nRequestID )
    {
        AsyncRequest*   par;
        if( FindRequest(nRequestID, &par ) )
        {
            if( pnRequestType )
            {
                *pnRequestType = par->nType;
            }
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    // Are we looking for just any request?
    else
    {
        // Assume 0 is UNKNOWN
        if( pnRequestType ) *pnRequestType = 0;

        return (m_listRequests.empty() ? FALSE : TRUE);
    }
}

BOOL CtRequestList::IsRequestTypePending(
    DWORD                   nRequestType,
    const CtReplyTarget*    pTarget) const  // = 0
{
    AsyncRequest*   par;
	CPointerList::const_iterator iter;

				   for( iter = m_listRequests.begin(); iter != m_listRequests.end(); ++iter )
				   {
		par = (AsyncRequest*)(*iter);
        if( par->nType == nRequestType &&
            (!pTarget || pTarget == par->pTarget) )
        {
            return TRUE;
        }
    }

    return FALSE;
}

BOOL CtRequestList::FindRequest(
    TREQUEST        nRequestID,
    AsyncRequest**  ppar /// = 0 
	) const
{
    AsyncRequest*   par;
	CPointerList::const_iterator iter;

	for( iter = m_listRequests.begin(); iter != m_listRequests.end(); ++iter )
    {
           par = (AsyncRequest*)(*iter);
        if( par->nID == nRequestID )
        {
            if( ppar )
            {
                *ppar = par;
            }

            return TRUE;
        }
    }

    return FALSE;
}

BOOL CtRequestList::RemoveRequest(
    TREQUEST        nRequestID,
    CtReplyTarget** ppTarget,       // = 0
    DWORD*          pnRequestType)  // = 0
{
    AsyncRequest*   par;

    if( FindRequest(nRequestID, &par ) )
    {
        if( ppTarget )
        {
            *ppTarget = par->pTarget;
        }

        if( pnRequestType )
        {
            *pnRequestType = par->nType;
        }

        m_listRequests.remove( par ); //  .RemoveAt(pos);
        if( par ) delete par;

        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

void CtRequestList::RemoveAllRequests(
    CtReplyTarget*  pTarget)    // = 0
{
    // Walk list, remove pending requests
    // for the requested reply target or all reply targets
    AsyncRequest*   par;
	CPointerList::const_iterator iter;

	iter = m_listRequests.begin();
	for(;;)
    {
		if( iter == m_listRequests.end() )
			break;
           par = (AsyncRequest*)(*iter);
        if( !pTarget || pTarget == par->pTarget )
        {
            m_listRequests.remove( par );   //.RemoveAt(posOld);
            if( par ) { delete par; par = NULL; }
			iter = m_listRequests.begin();
        }
		else
			++iter ;
    }
}

