// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tProviderList.h: CtProviderList class interface

#ifndef TPROVIDERLIST_H
#define TPROVIDERLIST_H

#include "tVarData.h"

class CtProviderList : public CtVariableData
{
public:
    operator const LPLINEPROVIDERLIST() const;

    LONG    GetProviderList();

    DWORD   GetNumProviders() const;
    DWORD   GetProviderPermanentID(DWORD nProvider) const;
    LPCSTR  GetProviderFilename(DWORD nProvider) const;

protected:
    virtual TRESULT FillBuffer();

private:
    const LPLINEPROVIDERLIST GetData() const;
};

// Inline member functions: For Compiler Eyes Only!

inline
CtProviderList::operator const LPLINEPROVIDERLIST() const
{
    return LPLINEPROVIDERLIST(m_pd);
}

inline
const LPLINEPROVIDERLIST CtProviderList::GetData() const
{
    assert(m_pd);
    return LPLINEPROVIDERLIST(m_pd);
}

inline
TRESULT CtProviderList::GetProviderList()
{
    return UpdateData();
}

inline
TRESULT CtProviderList::FillBuffer()
{
    assert(m_pd->dwTotalSize >= sizeof(LINEPROVIDERLIST));
    return ::TfxTapiFunc(::lineGetProviderList(CtLine::GetAppVersion(),
                                               LPLINEPROVIDERLIST(m_pd)),
                         TDBSTR("lineGetProviderList"));
}

inline
DWORD CtProviderList::GetNumProviders() const
{
    return GetData()->dwNumProviders;
}

inline
DWORD CtProviderList::GetProviderPermanentID(DWORD nProvider) const
{
    assert(nProvider < GetNumProviders());
    LPLINEPROVIDERENTRY alpe = (LPLINEPROVIDERENTRY)GetDataPtr(GetData()->dwProviderListOffset);
    assert(alpe);

    return alpe[nProvider].dwPermanentProviderID;
}

inline
const char*	CtProviderList::GetProviderFilename(DWORD nProvider) const
{
    assert(nProvider < GetNumProviders());
    LPLINEPROVIDERENTRY alpe = (LPLINEPROVIDERENTRY)GetDataPtr(GetData()->dwProviderListOffset);
    assert(alpe);

    return GetStringPtr(alpe[nProvider].dwProviderFilenameOffset,
                        alpe[nProvider].dwProviderFilenameSize);
}

#endif  // TPROVIDERLIST_H