// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tPhoneSink.h: CtLineSink class interface

#ifndef TPHONESINK_H
#define TPHONESINK_H

class CtPhone;

class CtPhoneSink
{
public:
    // Sink events (placeholders for overriding only)
    virtual void    OnPhoneButton(CtPhone* pPhone, DWORD nButtonOrLampID, DWORD nButtonMode, DWORD nButtonState) {}
    virtual void    OnPhoneClose(CtPhone* pPhone) {}
    virtual void    OnPhoneDevSpecific(CtPhone* pPhone, DWORD dwDevice, DWORD dwParam1, DWORD dwParam2, DWORD dwParam3) {}
    virtual void    OnPhoneReply(CtPhone* pPhone, TREQUEST nRequestID, TRESULT nResult, DWORD dwRequestType) {}
    virtual void    OnPhoneState(CtPhone* pPhone, DWORD dwPhoneStates, DWORD dwPhoneStateDetails) {}

#if (TAPI_CURRENT_VERSION >= 0x00020000)
    virtual void    OnPhoneRemove(CtPhone* pPhone, DWORD dwDeviceID) {}
#endif
};

#endif  // TPHONESINK_H
