// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tLineSink.h: CtLineSink class interface

#ifndef TLINESINK_H
#define TLINESINK_H

#include "TfxShared.h"

class CtLine;

class CtLineSink
{
public:
    // Sink events (placeholders for overriding only)
    virtual void    OnLineAddressState(CtLine* pLine, DWORD nAddressID, DWORD nAddressState) {}
    virtual void    OnLineNewCall(CtLine* pLine, HCALL hCall, DWORD nAddressID, DWORD nCallPriviledge) {}
    virtual void    OnLineClose(CtLine* pLine) {}
    virtual void    OnLineDevSpecific(CtLine* pLine, DWORD dwDevice, DWORD dwParam1, DWORD dwParam2, DWORD dwParam3) {}
    virtual void    OnLineDevSpecificFeature(CtLine* pLine, DWORD dwDevice, DWORD dwParam1, DWORD dwParam2, DWORD dwParam3) {}
    virtual void    OnLineDevState(CtLine* pLine, DWORD nDevState, DWORD dwParam2, DWORD dwParam3) {}
    virtual void    OnLineReply(CtLine* pLine, TREQUEST nRequestID, TRESULT nResult, DWORD dwRequestType) {}

#if (TAPI_CURRENT_VERSION >= 0x00020000)
    virtual void    OnLineAgentSpecific(CtLine* pLine, DWORD dwAgentExtensionIDIndex, DWORD dwHandlerSpecific1, DWORD dwHandlerSpecific2) {}
    virtual void    OnLineAgentStatus(CtLine* pLine, DWORD nAddressID, DWORD nAgentStatus, DWORD dwAgentStatusDetail) {}
    virtual void    OnLineProxyRequest(CtLine* pLine, LINEPROXYREQUEST* pProxyRequest) {}
    virtual void    OnLineRemove(CtLine* pLine, DWORD dwDeviceID) {}
#endif
};

#endif  // TLINESINK_H
