// tDevCfg.h: CtAddressCaps class interface

#ifndef TDEVCFG_H
#define TDEVCFG_H

#include "TfxAfxExt.h"
#include "tVarData.h"

class AFX_EXT_TFX CtDeviceConfig : public CtVariableData
{
public:
    operator const LPVARSTRING() const;

    TRESULT GetDeviceConfig(DWORD nLineID, LPCSTR pszDeviceClass = 0);
    TRESULT SetDeviceConfig(DWORD nLineID, LPCSTR pszDeviceClass = 0);
    TRESULT ConfigDialogEdit(DWORD nLineID, HWND hwndOwner, LPCSTR pszDeviceClass = 0);

    DWORD   GetLineDeviceID() const;
    LPCSTR  GetDeviceClass() const;

protected:
    virtual TRESULT FillBuffer();

private:
    DWORD   m_nLineID;
    CString m_sDeviceClass;

    const LPVARSTRING GetData() const;
};

// Inline member functions: For Compiler Eyes Only!

inline
CtAddressCaps::operator const LPLINEADDRESSCAPS() const
{
    return LPLINEADDRESSCAPS(m_pd);
}

inline
const LPLINEADDRESSCAPS CtAddressCaps::GetData() const
{
    ASSERT(m_pd);
    return LPLINEADDRESSCAPS(m_pd);
}

inline
TRESULT CtAddressCaps::GetAddressCaps(DWORD nLineID, DWORD nAddressID)
{
    ASSERT(CtLine::GetAppHandle());
    ASSERT(nLineID < CtLine::GetNumDevs());

    m_nLineID = nLineID;
    m_nAddressID = nAddressID;

    return UpdateData();
}

inline
TRESULT CtAddressCaps::FillBuffer()
{
    ASSERT(m_pd->dwTotalSize >= sizeof(LINEADDRESSCAPS));
    return ::TfxTapiFunc(::lineGetAddressCaps(CtLine::GetAppHandle(),
                                              m_nLineID, m_nAddressID,
                                              CtLine::GetApiVersion(m_nLineID),
                                              0, LPLINEADDRESSCAPS(m_pd)),
                         TDBSTR("lineGetAddressCaps"));
}

inline
DWORD CtAddressCaps::GetLineDeviceID() const
{
    return GetData()->dwLineDeviceID;
}

inline
LPCSTR CtAddressCaps::GetAddress() const
{
    return GetStringPtr(GetData()->dwAddressOffset,
                        GetData()->dwAddressSize);
}

inline
DWORD CtAddressCaps::GetAddressSharing() const
{
    return GetData()->dwAddressSharing;
}

inline
DWORD CtAddressCaps::GetAddressStates() const
{
    return GetData()->dwAddressStates;
}

inline
DWORD CtAddressCaps::GetCallInfoStates() const
{
    return GetData()->dwCallInfoStates;
}

inline
DWORD CtAddressCaps::GetCallerIDFlags() const
{
    return GetData()->dwCallerIDFlags;
}

inline
DWORD CtAddressCaps::GetCalledIDFlags() const
{
    return GetData()->dwCalledIDFlags;
}

inline
DWORD CtAddressCaps::GetConnectedIDFlags() const
{
    return GetData()->dwConnectedIDFlags;
}

inline
DWORD CtAddressCaps::GetRedirectionIDFlags() const
{
    return GetData()->dwRedirectionIDFlags;
}

inline
DWORD CtAddressCaps::GetRedirectingIDFlags() const
{
    return GetData()->dwRedirectingIDFlags;
}

inline
DWORD CtAddressCaps::GetCallStates() const
{
    return GetData()->dwCallStates;
}

inline
DWORD CtAddressCaps::GetDialToneModes() const
{
    return GetData()->dwDialToneModes;
}

inline
DWORD CtAddressCaps::GetBusyModes() const
{
    return GetData()->dwBusyModes;
}

inline
DWORD CtAddressCaps::GetSpecialInfo() const
{
    return GetData()->dwSpecialInfo;
}

inline
DWORD CtAddressCaps::GetDisconnectModes() const
{
    return GetData()->dwDisconnectModes;
}

inline
DWORD CtAddressCaps::GetMaxNumActiveCalls() const
{
    return GetData()->dwMaxNumActiveCalls;
}

inline
DWORD CtAddressCaps::GetMaxNumOnHoldCalls() const
{
    return GetData()->dwMaxNumOnHoldCalls;
}

inline
DWORD CtAddressCaps::GetMaxNumOnHoldPendingCalls() const
{
    return GetData()->dwMaxNumOnHoldPendingCalls;
}

inline
DWORD CtAddressCaps::GetMaxNumConference() const
{
    return GetData()->dwMaxNumConference;
}

inline
DWORD CtAddressCaps::GetMaxNumTransConf() const
{
    return GetData()->dwMaxNumTransConf;
}

inline
DWORD CtAddressCaps::GetAddrCapFlags() const
{
    return GetData()->dwAddrCapFlags;
}

inline
DWORD CtAddressCaps::GetCallFeatures() const
{
    return GetData()->dwCallFeatures;
}

inline
DWORD CtAddressCaps::GetRemoveFromConfCaps() const
{
    return GetData()->dwRemoveFromConfCaps;
}

inline
DWORD CtAddressCaps::GetRemoveFromConfState() const
{
    return GetData()->dwRemoveFromConfState;
}

inline
DWORD CtAddressCaps::GetTransferModes() const
{
    return GetData()->dwTransferModes;
}

inline
DWORD CtAddressCaps::GetParkModes() const
{
    return GetData()->dwParkModes;
}

inline
DWORD CtAddressCaps::GetForwardModes() const
{
    return GetData()->dwForwardModes;
}

inline
DWORD CtAddressCaps::GetMaxForwardEntries() const
{
    return GetData()->dwMaxForwardEntries;
}

inline
DWORD CtAddressCaps::GetMaxSpecificEntries() const
{
    return GetData()->dwMaxSpecificEntries;
}

inline
DWORD CtAddressCaps::GetMinFwdNumRings() const
{
    return GetData()->dwMinFwdNumRings;
}

inline
DWORD CtAddressCaps::GetMaxFwdNumRings() const
{
    return GetData()->dwMaxFwdNumRings;
}

inline
DWORD CtAddressCaps::GetMaxCallCompletions() const
{
    return GetData()->dwMaxCallCompletions;
}

inline
DWORD CtAddressCaps::GetCallCompletionConds() const
{
    return GetData()->dwCallCompletionConds;
}

inline
DWORD CtAddressCaps::GetCallCompletionModes() const
{
    return GetData()->dwCallCompletionModes;
}

inline
DWORD CtAddressCaps::GetNumCompletionMessages() const
{
    return GetData()->dwNumCompletionMessages;
}

inline
LPCSTR CtAddressCaps::GetCompletionMsgText(DWORD nMsg) const
{
    ASSERT(nMsg < GetNumCompletionMessages());
    return GetStringPtr(GetData()->dwCompletionMsgTextOffset +
                            GetData()->dwCompletionMsgTextEntrySize * nMsg,
                        GetData()->dwCompletionMsgTextEntrySize);
}

inline
DWORD CtAddressCaps::GetAddressFeatures() const
{
    return GetData()->dwAddressFeatures;
}

#endif  // TDEVCFG_H
