// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tCountryList.h: CtCountryList class interface

#ifndef TCOUNTRYLIST_H
#define TCOUNTRYLIST_H

#include "tVarData.h"

class CtCountryList : public CtVariableData
{
public:
    operator const LPLINECOUNTRYLIST() const;

    TRESULT GetCountryList();

	DWORD   GetNumCountries() const;
    DWORD   GetCountryCode(DWORD nCountry) const;
    LPCSTR  GetCountryName(DWORD nCountry) const;
    LPCSTR  GetSameAreaRule(DWORD nCountry) const;
    LPCSTR  GetLongDistanceRule(DWORD nCountry) const;
    LPCSTR  GetInternationalRule(DWORD nCountry) const;

protected:
    virtual TRESULT FillBuffer();

private:
    const LPLINECOUNTRYLIST GetData() const;
};

// Inline member functions: For Compiler Eyes Only!

inline
CtCountryList::operator const LPLINECOUNTRYLIST() const
{
	return LPLINECOUNTRYLIST(m_pd);
}

inline
const LPLINECOUNTRYLIST CtCountryList::GetData() const
{
    assert(m_pd);
    return LPLINECOUNTRYLIST(m_pd);
}

inline
TRESULT CtCountryList::GetCountryList()
{
    return UpdateData();
}

inline
TRESULT CtCountryList::FillBuffer()
{
    assert(m_pd->dwTotalSize >= sizeof(LINECOUNTRYLIST));
    // Get all countries at once. What good is just one?
    return ::TfxTapiFunc(::lineGetCountry(0, CtLine::GetAppVersion(),
                                          LPLINECOUNTRYLIST(m_pd)),
                         TDBSTR("lineGetCountry"));
}

inline
DWORD CtCountryList::GetNumCountries() const
{
    return GetData()->dwNumCountries;
}

inline
DWORD CtCountryList::GetCountryCode(DWORD nCountry) const
{
    assert(nCountry < GetNumCountries());
    LPLINECOUNTRYENTRY  alce = (LPLINECOUNTRYENTRY)GetDataPtr(GetData()->dwCountryListOffset);
    assert(alce);

    return alce[nCountry].dwCountryCode;
}

inline
LPCSTR CtCountryList::GetCountryName(DWORD nCountry) const
{
    assert(nCountry < GetNumCountries());
    LPLINECOUNTRYENTRY  alce = (LPLINECOUNTRYENTRY)GetDataPtr(GetData()->dwCountryListOffset);
    assert(alce);

    return GetStringPtr(alce[nCountry].dwCountryNameOffset,
                        alce[nCountry].dwCountryNameSize);
}

inline
LPCSTR CtCountryList::GetSameAreaRule(DWORD nCountry) const
{
    assert(nCountry < GetNumCountries());
    LPLINECOUNTRYENTRY  alce = (LPLINECOUNTRYENTRY)GetDataPtr(GetData()->dwCountryListOffset);
    assert(alce);

    return GetStringPtr(alce[nCountry].dwSameAreaRuleOffset,
                        alce[nCountry].dwSameAreaRuleSize);
}

inline
LPCSTR CtCountryList::GetLongDistanceRule(DWORD nCountry) const
{
    assert(nCountry < GetNumCountries());
    LPLINECOUNTRYENTRY  alce = (LPLINECOUNTRYENTRY)GetDataPtr(GetData()->dwCountryListOffset);
    assert(alce);

    return GetStringPtr(alce[nCountry].dwLongDistanceRuleOffset,
                        alce[nCountry].dwLongDistanceRuleSize);
}

inline
LPCSTR CtCountryList::GetInternationalRule(DWORD nCountry) const
{
    assert(nCountry < GetNumCountries());
    LPLINECOUNTRYENTRY  alce = (LPLINECOUNTRYENTRY)GetDataPtr(GetData()->dwCountryListOffset);
    assert(alce);

    return GetStringPtr(alce[nCountry].dwInternationalRuleOffset,
                        alce[nCountry].dwInternationalRuleSize);
}

#endif  // TCOUNTRYLIST_H
