// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tCallStatus.h: CtCallStatus struct interface

#ifndef TCALLSTATUS_H
#define TCALLSTATUS_H

#include "tVarData.h"

class CtCallStatus : public CtVariableData
{
public:
    TRESULT GetCallStatus(const CtCall* pCall);
    TRESULT GetCallStatus(const HCALL hCall);
    
    operator const LPLINECALLSTATUS() const;

public:
    // CallStatus wrappers

    DWORD   GetCallState() const;
    DWORD   GetCallStateMode() const;
    DWORD   GetCallPrivilege() const;
    DWORD   GetCallFeatures() const;

    DWORD   GetDevSpecificSize() const;
    void*   GetDevSpecificInfo() const;

#if (TAPI_CURRENT_VERSION >= 0x00020000)
    DWORD   GetCallFeatures2() const;
    SYSTEMTIME  GetStateEntryTime() const;
#endif

protected:
    virtual TRESULT FillBuffer();

private:
    HCALL   m_hCall;

    const LPLINECALLSTATUS GetData() const;
};

// Inline member functions: For Compiler Eyes Only!
#include "TfxUtil.h"

inline
CtCallStatus::operator const LPLINECALLSTATUS() const
{
    return LPLINECALLSTATUS(m_pd);
}

inline
const LPLINECALLSTATUS CtCallStatus::GetData() const
{
    assert(m_pd);
    return LPLINECALLSTATUS(m_pd);
}

inline
TRESULT CtCallStatus::GetCallStatus(const CtCall* pCall)
{
    assert(pCall->GetHandle());

    m_hCall = pCall->GetHandle();
    return UpdateData();
}

inline
TRESULT CtCallStatus::GetCallStatus(const HCALL hCall)
{
    assert(hCall);

    m_hCall = hCall;
    return UpdateData();
}

inline
TRESULT CtCallStatus::FillBuffer()
{
    assert(m_pd->dwTotalSize >= sizeof(LINECALLSTATUS));
    return ::TfxTapiFunc(::lineGetCallStatus(m_hCall,
                                           LPLINECALLSTATUS(m_pd)),
                         TDBSTR("lineGetCallStatus"));
}

inline
DWORD CtCallStatus::GetCallState() const
{
    return GetData()->dwCallState;
}

inline
DWORD CtCallStatus::GetCallStateMode() const
{
    return GetData()->dwCallStateMode;
}

inline
DWORD CtCallStatus::GetCallPrivilege() const
{
    return GetData()->dwCallPrivilege;
}

inline
DWORD CtCallStatus::GetCallFeatures() const
{
    return GetData()->dwCallFeatures;
}

inline
DWORD CtCallStatus::GetDevSpecificSize() const
{
    return GetData()->dwDevSpecificSize;
}

inline
void* CtCallStatus::GetDevSpecificInfo() const
{
    return (void*)((BYTE*)m_pd + GetData()->dwDevSpecificOffset);
}

#if (TAPI_CURRENT_VERSION >= 0x00020000)

inline
DWORD CtCallStatus::GetCallFeatures2() const
{
    return GetData()->dwCallFeatures2;
}

inline
SYSTEMTIME CtCallStatus::GetStateEntryTime() const
{
    return GetData()->tStateEntryTime;
}

#endif
#endif  // TCALLSTATUS_H
