// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tCallSink.h: CtCallSink class interface

#ifndef TCALLSINK_H
#define TCALLSINK_H

#include "TfxShared.h"

class CtCall;

class CtCallSink
{
public:
    // Sink events (placeholders for overriding only)
    virtual void    OnCallInfo(CtCall* pCall, DWORD nCallInfo) {}
    virtual void    OnCallState(CtCall* pCall, DWORD nCallState, DWORD dwParam2, DWORD nCallPriviledge) {}
    virtual void    OnCallGatherDigits(CtCall* pCall, DWORD nGatherTerm) {}
    virtual void    OnCallGenerate(CtCall* pCall, DWORD nGenerateTerm) {}
    virtual void    OnCallMonitorDigits(CtCall* pCall, char cDigit, DWORD nDigitMode) {}
    virtual void    OnCallMonitorMedia(CtCall* pCall, DWORD nMediaMode) {}
    virtual void    OnCallMonitorTone(CtCall* pCall, DWORD dwAppSpecific) {}
    virtual void    OnCallReply(CtCall* pCall, TREQUEST nRequestID, TRESULT tr, DWORD nRequestType) {}
};

#endif  // TCALLSINK_H
