// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// tCallList.h: CtCallList class interface

#ifndef TCALLLIST_H
#define TCALLLIST_H

#include "tVarData.h"

class CtCallList : public CtVariableData
{
public:
    operator const LPLINECALLLIST() const;

    TRESULT GetNewCalls(HLINE hLine);
    TRESULT GetNewCallsFromAddress(DWORD dwAddress);

	DWORD   GetNumCalls() const;
    HCALL   GetCall(DWORD nCall) const;

protected:
    virtual TRESULT FillBuffer();

private:
    HLINE   m_hLine;
    DWORD   m_nAddress;

    const LPLINECALLLIST GetData() const;
};

// Inline member functions: For Compiler Eyes Only!

inline
CtCallList::operator const LPLINECALLLIST() const
{
	return LPLINECALLLIST(m_pd);
}

inline
const LPLINECALLLIST CtCallList::GetData() const
{
    assert(m_pd);
    return LPLINECALLLIST(m_pd);
}

inline
TRESULT CtCallList::GetNewCalls(HLINE hLine)
{
    m_hLine = hLine;
    m_nAddress = (DWORD)-1;

    return UpdateData();
}

inline
TRESULT CtCallList::GetNewCallsFromAddress(DWORD nAddress)
{
    m_hLine = 0;
    m_nAddress = nAddress;

    return UpdateData();
}

inline
TRESULT CtCallList::FillBuffer()
{
    assert(m_pd->dwTotalSize >= sizeof(LINECALLLIST));
    return ::TfxTapiFunc(::lineGetNewCalls(m_hLine,
                                           m_nAddress,
                                           (m_hLine ? LINECALLSELECT_LINE : LINECALLSELECT_ADDRESS),
                                          LPLINECALLLIST(m_pd)),
                         TDBSTR("lineGetNewCalls"));
}

inline
DWORD CtCallList::GetNumCalls() const
{
    return GetData()->dwCallsNumEntries;
}

inline
HCALL CtCallList::GetCall(DWORD nCall) const
{
    assert(nCall < GetNumCalls());
    return *(HCALL*)GetDataPtr(GetData()->dwCallsOffset);
}

#endif  // TCALLLIST_H
