// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// TfxUtil.h: TFX utility function interfaces

#ifndef TFXUTIL_H
#define TFXUTIL_H

#include "tRepTarg.h" // CtReplyTarget

#ifdef _DEBUG

// Event and result tracing functions
void TfxEventTrace(DWORD nDevice, DWORD nMsg, DWORD nParam1, DWORD nParam2, DWORD nParam3);
void TfxResultTrace(TRESULT tr, LPCSTR szName, TREQUEST nRequestID = 0);

#define TDBSTR(s) s
#define TETRACE ::TfxEventTrace

#else   // !_DEBUG

inline void TfxEventTrace(DWORD nDevice, DWORD nMsg, DWORD nParam1, DWORD nParam2, DWORD nParam3) {}
inline void TfxResultTrace(TRESULT tr, LPCSTR szName, TREQUEST nRequestID = 0) {}

#define TDBSTR(s) 0
#define TETRACE 1 ? (void)0 : ::TfxEventTrace

#endif

// Inline functions will either trace or not depending on _DEBUG
inline
TRESULT TfxTapiFunc(TRESULT tr, LPCSTR szFuncName)
{
    TfxResultTrace(tr, szFuncName);
    return tr;
}

inline
TRESULT TfxTapiReply(TREQUEST nRequestID, TRESULT tr, LPCSTR szReplyName)
{
    TfxResultTrace(tr, szReplyName, nRequestID);
    return tr;
}

// Just really useful
#define DIM(rg) (sizeof(rg)/sizeof(*rg))

// Win95 TAPI Recovery Support
class TapiRecover
{
public:
    void PreInitialize();
    void Initialize(void* happ);
    void Shutdown();

private:
    virtual const char* SubKeyName() =0;
    virtual long        ShutdownApp(void* happ) =0;
};

class LineTapiRecover : public TapiRecover
{
private:
    virtual const char* SubKeyName() { return "Lines"; }
    virtual long        ShutdownApp(void* happ) { return lineShutdown((HLINEAPP)happ); }
};

class PhoneTapiRecover : public TapiRecover
{
private:
    virtual const char* SubKeyName() { return "Phones"; }
    virtual long        ShutdownApp(void* happ) { return phoneShutdown((HPHONEAPP)happ); }
};

#endif  // TFXUTIL_H
