// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// TfxShared.h: Shared includes for lines and phones

#ifndef TFXSHARED_H
#define TFXSHARED_H

#include <tapi.h>

#define TSUCCEEDED(tr)  (tr == 0)
#define TFAILED(tr)     (tr < 0)
#define TPENDING(tr)    (tr > 0)

// Just so these look different from LONG (which has no meaning)
typedef LONG TRESULT;
typedef LONG TREQUEST;

// Just for documentation
#define tfxasync

#ifdef WIN32
#pragma comment(lib, "tapi32.lib")
#else
#error The TFX is not currently supporting Win3.x
#endif

#ifndef BUILD_TFX
    #ifdef WIN32
        #if TAPI_CURRENT_VERSION < 0x00020000
            #ifdef _DEBUG
                #pragma comment(lib, "tfx14d.lib")
            #else
                #pragma comment(lib, "tfx14.lib")
            #endif
        #else
            #ifdef _DEBUG
                #pragma comment(lib, "tfx20d.lib")
            #else
                #pragma comment(lib, "tfx20.lib")
            #endif
        #endif
    #else
        #error The TFX is not currently supporting Win3.x
    #endif
#endif

#endif  // TFXSHARED_H
