// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// TfxPhoneHelper.cpp: TFX global helper functions

#include "stdafx.h"
#include "TfxPhone.h"
#include "TfxUtil.h"

TRESULT TfxPhoneInitialize(
    CtAppSink*  pAppSink,
    LPCSTR      szAppName,
    HINSTANCE   hInst)
{
    char szFilePath[_MAX_PATH];
    ::GetModuleFileName( NULL, szFilePath, _MAX_PATH );
	for( int i = _MAX_PATH; i >= 0; i-- ) 
	{
		if( szFilePath[i] == '\\' ) 
			break;
		if( szFilePath[i] == '.' ) 
			szFilePath[i] = '\0';
	}
    TRESULT tr = CtPhone::Initialize(pAppSink,
                                    (szAppName ? szAppName : (szFilePath+i) ),
                                    (hInst ? hInst : ::GetModuleHandle( NULL ) ));
    if( TSUCCEEDED(tr) && CtPhone::GetNumDevs() < 1 )
    {
        ::TfxPhoneShutdown();
        tr = PHONEERR_OPERATIONFAILED;
    }
    return tr;
}

void TfxPhoneShutdown()
{
    CtPhone::Shutdown();
}

DWORD TfxGetNumPhones()
{
    return CtPhone::GetNumDevs();
}

TRESULT TfxPhoneGetIcon(
    DWORD   nPhoneID,
    LPHICON phicon,
    LPCSTR  pszDeviceClass) // = 0
{
    return CtPhone::GetIcon(nPhoneID, phicon, pszDeviceClass);
}