// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// TfxLineHelper.cpp: TFX global helper functions

#include "stdafx.h"
#include "TfxLine.h"
#include "TfxUtil.h"

TRESULT TfxLineInitialize(
    CtAppSink*  pAppSink,
    LPCSTR      szAppName,
    HINSTANCE   hInst)
{
    char szFilePath[_MAX_PATH];
    ::GetModuleFileName( NULL, szFilePath, _MAX_PATH );
	for( int i = _MAX_PATH; i >= 0; i-- ) 
	{
		if( szFilePath[i] == '\\' ) 
			break;
		if( szFilePath[i] == '.' ) 
			szFilePath[i] = '\0';
	}
    TRESULT tr = CtLine::Initialize(pAppSink,
                                    (szAppName ? szAppName : (szFilePath+i) ),
                                    (hInst ? hInst : ::GetModuleHandle( NULL ) ));
    if( TSUCCEEDED(tr) && CtLine::GetNumDevs() < 1 )
    {
        ::TfxLineShutdown();
        tr = LINEERR_OPERATIONFAILED;
    }

    return tr;
}

void TfxLineShutdown()
{
    CtLine::Shutdown();
}

// Assumes len(pszAppName) = MAX_PATH + 1
static
void GetShortAppName(char* pszAppName)
{
    ::GetModuleFileName(0, pszAppName, MAX_PATH);
    ::GetShortPathName(pszAppName, pszAppName, MAX_PATH);
}

TRESULT TfxGetAppPriority(
    DWORD       nMediaMode,
    LPDWORD     pnPriority,
    LPLINEEXTENSIONID const pExtID, // = 0
    DWORD       nRequestMode,   // = LINEREQUESTMODE_MAKECALL
    LPVARSTRING pvsExtName) // = 0
{
    char szAppName[MAX_PATH + 1];
    ::GetShortAppName(szAppName);

    return ::TfxTapiFunc(::lineGetAppPriority(szAppName,
                                              nMediaMode,
                                              pExtID,
                                              nRequestMode,
                                              pvsExtName,
                                              pnPriority),
                         TDBSTR("lineGetAppPriority"));
}

TRESULT TfxSetAppPriority(
    DWORD       nMediaMode,
    DWORD       nPriority,
    LPLINEEXTENSIONID const pExtID, // = 0
    DWORD       nRequestMode,   // = LINEREQUESTMODE_MAKECALL
    LPCSTR      pszExtName) // = 0
{
    char szAppName[MAX_PATH + 1];
    ::GetShortAppName(szAppName);

    return ::TfxTapiFunc(::lineSetAppPriority(szAppName,
                                              nMediaMode,
                                              pExtID,
                                              nRequestMode,
                                              pszExtName,
                                              nPriority),
                         TDBSTR("lineSetAppPriority"));
}

TRESULT TfxRegisterRequestRecipient(
    DWORD   dwRequestMode)  // = LINEREQUESTMODE_MAKECALL
{
    return CtLine::RegisterRequestRecipient(dwRequestMode, TRUE);
}

void TfxUnregisterRequestRecipient(
    DWORD   dwRequestMode)  // = LINEREQUESTMODE_MAKECALL
{
    CtLine::RegisterRequestRecipient(dwRequestMode, FALSE);
}

TRESULT TfxGetMakeCallRequest(LPLINEREQMAKECALL plmc)
{
    return CtLine::GetMakeCallRequest(plmc);
}

TRESULT TfxGetMediaCallRequest(LPLINEREQMEDIACALL plmc)
{
    return CtLine::GetMediaCallRequest(plmc);
}

DWORD TfxGetNumLines()
{
    return CtLine::GetNumDevs();
}

TRESULT TfxLineConfigDialog(
    DWORD   nLineID,
    HWND    hwndOwner,      // = 0
    LPCSTR  szDeviceClass)  // = 0
{
    return CtLine::ConfigDialog(nLineID, hwndOwner, szDeviceClass);
}

TRESULT TfxLineTranslateDialog(
    DWORD   nLineID,
    HWND    hwndOwner,      // = 0
    LPCSTR  szAddressIn)    // = 0
{
    return CtLine::TranslateDialog(nLineID, hwndOwner, szAddressIn);
}

TRESULT TfxSetCurrentLocation(
    DWORD   nLocationID)
{
    return CtLine::SetCurrentLocation(nLocationID);
}

TRESULT TfxLineGetIcon(
    DWORD   nLineID,
    LPHICON phicon,
    LPCSTR  pszDeviceClass) // = 0
{
    return CtLine::GetIcon(nLineID, phicon, pszDeviceClass);
}