// This code is a part of the Telephony Framework C++ Library.
// Copyright (C) 1997 Chris Sells. All rights reserved.
// TfxLine.h: All necessary TFX line related classes

#ifndef TFXLINE_H
#define TFXLINE_H

#include "TfxShared.h"
#include "tAppSink.h"
#include "tLine.h"
#include "tLineSink.h"
#include "tCall.h"
#include "tCallSink.h"
#include "tLineDevCaps.h"
#include "tAddressCaps.h"
#include "tTranslateOutput.h"
#include "tTranslateCaps.h"
#include "tProviderList.h"
#include "tCountryList.h"
#include "tCallList.h"
#include "tCallInfo.h"
#include "tCallStatus.h"
#include "tDeviceID.h"

DWORD TfxGetNumLines();
TRESULT TfxLineInitialize(CtAppSink* pAppSink = 0,
                          LPCSTR szAppName = 0,
                          HINSTANCE hInst = 0);
void TfxLineShutdown();

TRESULT TfxRegisterRequestRecipient(DWORD dwRequestMode = LINEREQUESTMODE_MAKECALL);
void TfxUnregisterRequestRecipient(DWORD dwRequestMode = LINEREQUESTMODE_MAKECALL);

TRESULT TfxGetAppPriority(DWORD nMediaMode,
                          LPDWORD pnPriority,
                          LPLINEEXTENSIONID const pExtID = 0,
                          DWORD nRequestMode = LINEREQUESTMODE_MAKECALL,
                          LPVARSTRING pvsExtName = 0);

TRESULT TfxSetAppPriority(DWORD nMediaMode,
                          DWORD nPriority,
                          LPLINEEXTENSIONID const pExtID = 0,
                          DWORD nRequestMode = LINEREQUESTMODE_MAKECALL,
                          LPCSTR pszExtName = 0);

TRESULT TfxGetMakeCallRequest(LPLINEREQMAKECALL plmc);
TRESULT TfxGetMediaCallRequest(LPLINEREQMEDIACALL plmc);

TRESULT TfxLineConfigDialog(DWORD nLineID, HWND hwndOwner, LPCSTR szDeviceClass = 0);
TRESULT TfxLineTranslateDialog(DWORD nLineID, HWND hwndOwner, LPCSTR szAddressIn = 0);
TRESULT TfxLineGetIcon(DWORD nLineID, LPHICON phicon, LPCSTR pszDeviceClass = 0);

TRESULT TfxSetCurrentLocation(DWORD nLocationID);

#endif  // TFXLINE_H