// InvisibleWindow.cpp

//#include "stdafx.h"
#include "InvisibleWindow.h"

WindowClass InvisibleWindow::s_wc(__TEXT("InvisibleWindowClass"), InvisibleWindowProc);

bool InvisibleWindow::Create(InvisibleWindowSink* pSink)
{
    assert(pSink && "InvisibleWindowSink required");

    if( !m_hwnd )
    {
        if( s_wc.IsRegistered() )
        {
            m_hwnd = CreateWindow(s_wc.ClassName(), __TEXT(""), WS_POPUP | WS_DISABLED, 0, 0, 0, 0, 0, 0, GetModuleHandle(0), 0);

            if( m_hwnd )
            {
                SetWindowLong(m_hwnd, GWL_USERDATA, (LONG)pSink);
            }
        }
    }

    return m_hwnd ? true : false;
}

LRESULT CALLBACK InvisibleWindowProc(HWND hwnd, UINT nMsg, WPARAM wparam, LPARAM lparam)
{
    InvisibleWindowSink*    pSink = (InvisibleWindowSink*)GetWindowLong(hwnd, GWL_USERDATA);
    if( pSink ) return pSink->OnWindowMessage(hwnd, nMsg, wparam, lparam);
    else return DefWindowProc(hwnd, nMsg, wparam, lparam);
}

