// PhoneNoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PhoneNoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPhoneNoDlg dialog

#define INVALID_LINE ((DWORD)-1)

CPhoneNoDlg::CPhoneNoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPhoneNoDlg::IDD, pParent),
    m_rgbShouldShowLines(0),
    m_nLineID(INVALID_LINE),
    m_nAddressID(0)
{
	//{{AFX_DATA_INIT(CPhoneNoDlg)
	m_sAreaCode = _T("");
	m_sDialString = _T("");
	m_sPhoneNo = _T("");
	m_bBuildCanonical = FALSE;
	//}}AFX_DATA_INIT
}

BOOL CPhoneNoDlg::ShouldShowLine(DWORD nLineID)
{
    if( m_rgbShouldShowLines )
    {
        return m_rgbShouldShowLines[nLineID];
    }
    else
    {
        return TRUE;
    }
}

void CPhoneNoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPhoneNoDlg)
	DDX_Control(pDX, IDC_ADDRESSES, m_listAddresses);
	DDX_Control(pDX, IDC_CONFIG_DIALOG, m_btnConfigDialog);
	DDX_Control(pDX, IDC_TRANSLATE_DIALOG, m_btnTranslateDialog);
	DDX_Control(pDX, IDC_LINE_ICON, m_iconLine);
	DDX_Control(pDX, IDC_AREA_CODE, m_editAreaCode);
	DDX_Control(pDX, IDOK, m_btnOK);
	DDX_Control(pDX, IDC_LINES, m_listLines);
	DDX_Control(pDX, IDC_LOCATIONS, m_listLocations);
	DDX_Control(pDX, IDC_COUNTRY_CODE, m_listCountryCodes);
	DDX_Text(pDX, IDC_AREA_CODE, m_sAreaCode);
	DDX_Check(pDX, IDC_BUILD_CANONICAL, m_bBuildCanonical);
	DDX_Text(pDX, IDC_DIAL_STRING, m_sDialString);
	DDX_Text(pDX, IDC_PHONE_NO, m_sPhoneNo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPhoneNoDlg, CDialog)
	//{{AFX_MSG_MAP(CPhoneNoDlg)
	ON_CBN_SELCHANGE(IDC_LOCATIONS, OnSelchangeLocations)
	ON_EN_CHANGE(IDC_AREA_CODE, OnChangeAreaCode)
	ON_BN_CLICKED(IDC_BUILD_CANONICAL, OnChangeBuildCanonical)
	ON_EN_CHANGE(IDC_PHONE_NO, OnChangePhoneNo)
	ON_CBN_SELCHANGE(IDC_COUNTRY_CODE, OnSelchangeCountryCode)
	ON_CBN_SELCHANGE(IDC_LINES, OnSelchangeLines)
	ON_BN_CLICKED(IDC_CONFIG_DIALOG, OnConfigDialog)
	ON_BN_CLICKED(IDC_TRANSLATE_DIALOG, OnTranslateDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPhoneNoDlg message handlers

BOOL CPhoneNoDlg::OnInitDialog() 
{
    // Set initial dialog values based on input phone no.
    // (before the values are shown in the dialog)
    m_sAreaCode = m_pno.GetAreaCode();
    m_sPhoneNo = m_pno.GetPhoneNo();

    // Check for canonical setting
    LPCSTR  pszCountryCode = m_pno.GetCountryCode();

    // Assume we're going to have enough info to fill out
    // the canonical format if we have a country code or
    // we don't yet have anything (as we'll set defaults)
    if( pszCountryCode ||
        /*!pszCountryCode && */ m_sAreaCode.IsEmpty() && m_sPhoneNo.IsEmpty() )
    {
        m_bBuildCanonical = TRUE;
    }
    else
    {
        m_bBuildCanonical = FALSE;
    }

    // Set location defaults if necessary
    CtPhoneNo   pnoLocation;
    pnoLocation.ResetToLocation();

    // Set the default area code if we don't have one and
    // both the country code and the phone no. aren't set
    // (because the area code is optional for canonical format)
    if( m_sAreaCode.IsEmpty() &&
        !(pszCountryCode && !m_sPhoneNo.IsEmpty()) )
    {
        m_sAreaCode = pnoLocation.GetAreaCode();
    }

    // Set the country code if we don't have one
    if( !pszCountryCode )
    {
        pszCountryCode = pnoLocation.GetCountryCode();
    }

    CDialog::OnInitDialog();

    // Populate the country code list (default to US if all else fails)
    PopulateCountryCodes(DWORD(::atol(pszCountryCode ? pszCountryCode : "1")));

    // Populate locations (also happens after the translate dialog)
    PopulateLocations();

    // Set default line to first shown line
    if( m_nLineID == INVALID_LINE )
    {
        for( DWORD nLineID = 0; nLineID < ::TfxGetNumLines(); nLineID++ )
        {
            if( ShouldShowLine(nLineID) )
            {
                m_nLineID = nLineID;
                break;
            }
        }
    }

    // Populate lines list box
    PopulateLines();

    // Populate addresses list box
    PopulateAddresses();

    // Show initial line icon
    ShowLineIcon();

    // Update controls based on current data
    UpdateControls();    

    return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPhoneNoDlg::PopulateCountryCodes(DWORD nCountryCode)
{
    CtCountryList   cl;
    if( TSUCCEEDED(cl.GetCountryList()) )
    {
        for( DWORD i = 0; i < cl.GetNumCountries(); i++ )
        {
            CString sCountry;
            sCountry.Format("%s (%d)", cl.GetCountryName(i), cl.GetCountryCode(i));
            
            int nIndex = m_listCountryCodes.AddString(sCountry);
            m_listCountryCodes.SetItemData(nIndex, cl.GetCountryCode(i));

            // Set the correct initial country
            if( cl.GetCountryCode(i) == nCountryCode )
            {
                m_listCountryCodes.SetCurSel(nIndex);
                nCountryCode = 0;   // Don't pick another one
            }
        }
    }
}

void CPhoneNoDlg::PopulateLocations()
{
    m_listLocations.ResetContent();

    // Populate the locations list box
    CtTranslateCaps tc;
    if( TSUCCEEDED(tc.GetTranslateCaps()) )
    {
        for( DWORD i = 0; i < tc.GetNumLocations(); i++ )
        {
            int nIndex = m_listLocations.AddString(tc.GetLocationName(i));
            if( nIndex >= 0 )
            {
                m_listLocations.SetItemData(nIndex, tc.GetPermanentLocationID(i));
                
                // Set the current location
                if( tc.GetPermanentLocationID(i) == tc.GetCurrentLocationID() )
                {
                    m_listLocations.SetCurSel(nIndex);
                }
            }
        }
    }
}

void CPhoneNoDlg::PopulateLines()
{
    CtLineDevCaps   ldc;
    for( DWORD nLineID = 0; nLineID < ::TfxGetNumLines(); nLineID++ )
    {
        if( ShouldShowLine(nLineID) &&
            TSUCCEEDED(ldc.GetDevCaps(nLineID)) )
        {
            CString sLine;
            sLine.Format("Line %d: %s", nLineID + 1, ldc.GetLineName());
            int nIndex = m_listLines.AddString(sLine);
            if( nIndex >= 0 )
            {
                m_listLines.SetItemData(nIndex, nLineID);

                if( nLineID == m_nLineID )
                {
                    m_listLines.SetCurSel(nIndex);
                }
            }
        }
    }
}

void CPhoneNoDlg::PopulateAddresses()
{
    m_listAddresses.ResetContent();

    if( m_nLineID != INVALID_LINE )
    {
        CtLineDevCaps   ldc;
        if( TSUCCEEDED(ldc.GetDevCaps(m_nLineID)) )
        {
            DWORD   nAddrs = ldc.GetNumAddresses();
            for( DWORD nAddressID = 0; nAddressID < nAddrs; nAddressID++ )
            {
                CtAddressCaps   ac;
                if( TSUCCEEDED(ac.GetAddressCaps(m_nLineID, nAddressID)) )
                {
                    CString sAddress;
                    LPCSTR  pszAddressName = ac.GetAddress();
                    if( pszAddressName && *pszAddressName )
                    {
                        sAddress.Format("Address %d: %s", nAddressID + 1, pszAddressName);
                    }
                    else
                    {
                        sAddress.Format("Address %d", nAddressID + 1);
                    }

                    int nIndex = m_listAddresses.AddString(sAddress);
                    if( nIndex >= 0 )
                    {
                        m_listAddresses.SetItemData(nIndex, nAddressID);

                        if( nAddressID == m_nAddressID )
                        {
                            m_listAddresses.SetCurSel(nIndex);
                        }
                    }
                }
            }
        }
    }
}

void CPhoneNoDlg::ShowLineIcon()
{
    HICON   hicon = 0;
    if( m_nLineID != INVALID_LINE )
    {
        ::TfxLineGetIcon(m_nLineID, &hicon, m_sDeviceClass);
    }

    m_iconLine.SetIcon(hicon);
}

void CPhoneNoDlg::UpdateControls()
{
    if( UpdateData(TRUE) )
    {
        int     nCountryIndex = m_listCountryCodes.GetCurSel();
        DWORD   nCountryCode = (nCountryIndex >= 0 ? m_listCountryCodes.GetItemData(nCountryIndex) : 0);

        // Calculate phone number
        if( m_bBuildCanonical )
        {
            char    szCountryBuf[8];    // country codes size = 8
            m_pno.SetCountryCode(nCountryCode
                                 ? ::itoa(nCountryCode, szCountryBuf, 10)
                                 : 0);
            m_pno.SetAreaCode(m_sAreaCode);
            m_pno.SetPhoneNo(m_sPhoneNo);
        }
        else
        {
            m_pno.SetWholePhoneNo(m_sPhoneNo);
        }

        // Use phone no and line ID to translate phone number to show
        CString sDisplayable;
        LPCSTR  pszTranslatable;

        // Only map letters to digits in the US (where I know how)
        if( nCountryCode == 1 )
        {
            pszTranslatable = m_pno.GetTranslatable();
        }
        else
        {
            pszTranslatable = m_pno.GetTranslatable(0);
        }

        CtTranslateOutput   to;
        if( m_nLineID != INVALID_LINE &&
            pszTranslatable &&
            TSUCCEEDED(to.TranslateAddress(m_nLineID, pszTranslatable)) )
        {
            sDisplayable = to.GetDisplayableString();
        }
        else
        {
            sDisplayable = m_pno.GetDisplayable();
        }

        // Cache translated phone no.
        m_sDialable = sDisplayable;

        // Show phone calculated phone no.
        SetDlgItemText(IDC_DIAL_STRING, sDisplayable);

        // Enable county code and area code fields based on check box
        m_listCountryCodes.EnableWindow(m_bBuildCanonical);
        m_editAreaCode.EnableWindow(m_bBuildCanonical);

        // Enable sub-dialogs if we've got a line
        m_btnTranslateDialog.EnableWindow(m_nLineID != INVALID_LINE);
        m_btnConfigDialog.EnableWindow(m_nLineID != INVALID_LINE);

        // Only allow OK if proper options are set
        // i.e. make sure a line is selected, that either
        // we're building a canonical phone no. and we can or
        // we're not building a canonical phone no. and we have a phone no.
        BOOL    bDataIsOK = FALSE;
        if( m_nLineID != INVALID_LINE &&
            (m_bBuildCanonical && m_pno.GetCanonical() ||
             !m_bBuildCanonical && m_pno.GetPhoneNo()) )
        {
            bDataIsOK = TRUE;
        }

        m_btnOK.EnableWindow(bDataIsOK);
    }
}

void CPhoneNoDlg::OnChangeAreaCode() 
{
	UpdateControls();
}

void CPhoneNoDlg::OnChangeBuildCanonical() 
{
	UpdateControls();
}

void CPhoneNoDlg::OnChangePhoneNo() 
{
	UpdateControls();
}

void CPhoneNoDlg::OnSelchangeCountryCode() 
{
	UpdateControls();
}

void CPhoneNoDlg::OnSelchangeLocations() 
{
    DWORD   nLocationID = m_listLocations.GetItemData(m_listLocations.GetCurSel());
    ::TfxSetCurrentLocation(nLocationID);
	UpdateControls();
}

void CPhoneNoDlg::OnSelchangeLines() 
{
    // Cache line ID
    int     nLineIndex = m_listLines.GetCurSel();
    m_nLineID = (nLineIndex < 0 ? INVALID_LINE : m_listLines.GetItemData(nLineIndex));

    // Update addresses
    PopulateAddresses();

    // Show line icon and update the rest of the controls based on the new line
    ShowLineIcon();
	UpdateControls();
}

void CPhoneNoDlg::OnConfigDialog() 
{
    if( TSUCCEEDED(::TfxLineConfigDialog(m_nLineID, GetSafeHwnd(),
                                         m_sDeviceClass)) )
    {
        UpdateControls();
    }
}

void CPhoneNoDlg::OnTranslateDialog() 
{
    if( TSUCCEEDED(::TfxLineTranslateDialog(m_nLineID, GetSafeHwnd(),
                                            m_pno.GetTranslatable())) )
    {
        // Locations may have changed...
        PopulateLocations();

        UpdateControls();
    }
}
