// uicall.cpp

#include "pch.h"
#include "wavetsp.h"
#include "uicall.h"

CuiCall::CuiCall(
    HTAPIDIALOGINSTANCE htDlgInst,
    TUISPIDLLCALLBACK   lpfnUIDLLCallback,
    LPCSTR              pszAddress,
    LINEDIALPARAMS*     pdp,
    TSPUIDATA*          pData)
:
    m_htDlgInst(htDlgInst),
    m_pfnCallback(lpfnUIDLLCallback),
    m_pData(pData),
    m_pdp(pdp),
    m_dsAddress(this, pszAddress)
{
}

bool CuiCall::Dial(HWND hwndDialog)
{
    m_hwndDialog = hwndDialog;
    if( m_dsAddress.Dial(WAVE_MAPPER, m_pdp->dwDigitDuration, m_pdp->dwDialPause) )
    {
        SetCallState(LINECALLSTATE_DIALING);
        return true;
    }

    return false;
}

void CuiCall::SetCallState(DWORD dwCallState)
{
    Callback(dwCallState, 0);
}

void CuiCall::Cancel()
{
    m_dsAddress.Cancel();
    Callback(0, LINEERR_OPERATIONFAILED);
}

// CtDialStringSink
void CuiCall::OnDialDone()
{
    SetCallState(LINECALLSTATE_CONNECTED);
    EndDialog(m_hwndDialog, IDOK);
}

void CuiCall::OnDialError()
{
    SetCallState(LINECALLSTATE_IDLE);
    EndDialog(m_hwndDialog, IDABORT);
}

void CuiCall::Callback(DWORD nCallState, LONG tr)
{
    m_pData->nCallState = nCallState;
    m_pData->tr = tr;
    m_pfnCallback((DWORD)m_htDlgInst, TUISPIDLL_OBJECT_DIALOGINSTANCE, m_pData, sizeof(*m_pData));

    // Can only complete asynch operation once
    m_pData->dwRequestID = 0;
}

