// tspCall.h

#ifndef TSPCALL_H
#define TSPCALL_H

#include "wavetsp.h"
#include "tspline.h"

class CtspCall
{
public:
    CtspCall(CtspLine* pLine, HTAPICALL htCall);
    ~CtspCall();

    CtspLine*   GetLine();

    bool    Dial();
    void    Drop();

    DWORD   GetCallState();
    void    SetCallState(DWORD dwCallState, DWORD dwCallStateDetail = 0);

    LONG    StartDial(HINSTANCE hinst, HPROVIDER hProvider, DWORD dwRequestID,
                      const wchar_t* pwszAddress, const LINEDIALPARAMS& dp);

private:
    CtspLine*       m_pLine;
    DWORD           m_dwCallState;
    DWORD           m_dwCallStateDetail;
    HTAPICALL       m_htCall;
};

#endif  // TSPCALL_H
