// WaveTsp.h

#ifndef WAVETSP_H
#define WAVETSP_H

#define DIM(rg) (sizeof(rg)/sizeof(*rg))

// Data sent back and forth between UI and TSP during a dial operation
class CtspCall;

struct TSPUIDATA
{
    CtspCall*   pCall;          // Call operation is happening on
    DWORD       dwRequestID;    // Asynch. operation ID
    LONG        tr;             // Asynch, operation result
    DWORD       nCallState;     // New call state
};

#define DEBUGTSP
#if defined(_DEBUG) && defined(DEBUGTSP)

enum ParamType
{
    ptDword,
    ptString,
};

enum ParamDirection
{
    dirIn,
    dirOut,
};

struct FUNC_PARAM
{
    const char*     pszVal;
    DWORD           dwVal;
    ParamType       pt;
    ParamDirection  dir;
};

struct FUNC_INFO
{
    const char* pszFuncName;
    DWORD       dwNumParams;
    FUNC_PARAM* rgParams;
    LONG        lResult;
};

void Prolog(FUNC_INFO* pInfo);
LONG Epilog(FUNC_INFO* pInfo, LONG lResult);

#define BEGIN_PARAM_TABLE(fname) \
    const char* __pszFname = fname; \
    FUNC_PARAM __params[] = {

#define DWORD_IN_ENTRY(p) { #p, (DWORD)p, ptDword, dirIn },
#define DWORD_OUT_ENTRY(p) { #p, (DWORD)p, ptDword, dirOut },
#define STRING_IN_ENTRY(p) { #p, (DWORD)p, ptString, dirIn },
#define STRING_OUT_ENTRY(p) { #p, (DWORD)p, ptString, dirOut },

#define END_PARAM_TABLE() \
    }; FUNC_INFO __info = { __pszFname, DIM(__params), __params }; \
    Prolog(&__info);

#define EPILOG(r) Epilog(&__info, r)

#define TSPTRACE TspTrace
void TspTrace(LPCTSTR pszFormat, ...);

#else   // !_DEBUG

#define EPILOG(r) r

#define BEGIN_PARAM_TABLE(fname)
#define DWORD_IN_ENTRY(p)
#define DWORD_OUT_ENTRY(p)
#define STRING_IN_ENTRY(p)
#define STRING_OUT_ENTRY(p)
#define END_PARAM_TABLE()

#define TSPTRACE TspTrace
inline void TspTrace(LPCTSTR pszFormat, ...) {}

#endif  // _DEBUG

#endif  // WAVETSP_H