// setup.cpp

#include "sepch.h"

extern bool GetPermanentProviderID(LPCSTR pszProvider, DWORD* pdwID);

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR pszCmdLine, int)
{
    LPCSTR pszProvider = "wavetsp.tsp";
    LPCSTR pszTitle = "TSP Installation";
    LPCSTR pszMessage = 0;

    // Remove the TSP
    if( strcmpi(pszCmdLine, "/remove") == 0 )
    {
        DWORD dwID;
        if( GetPermanentProviderID(pszProvider, &dwID) )
        {
            if( lineRemoveProvider(dwID, 0) == 0 )
            {
                pszMessage = "TSP removed.";
            }
            else
            {
                pszMessage = "TSP cannot be removed.";
            }
        }
        else
        {
            pszMessage = "TSP not installed.";
        }
    }
    // Add the TSP
    else
    {
        DWORD   dwID;
        switch( lineAddProvider(pszProvider, 0, &dwID) )
        {
        case 0:
            if( MessageBox(0, "TSP successfully installed. Windows must be restarted.", pszTitle, MB_SETFOREGROUND) == IDOK )
            {
                ExitWindowsEx(EWX_REBOOT, 0);
            }
        break;

        case LINEERR_NOMULTIPLEINSTANCE:
            pszMessage = "TSP already installed.";
        break;

        default:
            pszMessage = "Unable to install TSP.";
        break;
        }
    }

    if( pszMessage )
    {
        MessageBox(0, pszMessage, pszTitle, MB_SETFOREGROUND);
    }

    return 0;
}
