// tDaemonDlg.h : header file
//

#if !defined(AFX_TDAEMONDLG_H__1A21B6DA_5147_11D1_A84F_0080C7667ABF__INCLUDED_)
#define AFX_TDAEMONDLG_H__1A21B6DA_5147_11D1_A84F_0080C7667ABF__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

/////////////////////////////////////////////////////////////////////////////
// CtDaemonDlg dialog

class CtDaemonDlg :
    public CDialog,
    public CtLineSink,
    public CtCallSink
{
// Construction
public:
	CtDaemonDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CtDaemonDlg)
	enum { IDD = IDD_TDAEMON_DIALOG };
	CEdit	m_editLog;
	CButton	m_btnStop;
	CButton	m_btnStart;
	long	m_nAreaEnd;
	long	m_nAreaStart;
	long	m_nCountryEnd;
	long	m_nCountryStart;
	long	m_nPhoneNoEnd;
	long	m_nPhoneNoStart;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CtDaemonDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
    HICON   m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CtDaemonDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnStart();
	afx_msg void OnStop();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    // Handle CtLineSink event
    virtual void OnLineClose(CtLine* pLine);

    // Handle CtCallSink events
    virtual void OnCallState(CtCall* pCall, DWORD nCallState, DWORD dwParam2, DWORD nCallPriviledge);
    virtual void OnCallReply(CtCall* pCall, TRESULT nRequestID, TREQUEST nResult, DWORD nRequestType);

private:
	void ReadData(HANDLE hComm);
    bool    OpenValidLine();
    void    DialNext();
	void    Dial();
    void    LogStatus(LPCSTR pszFormat, ...);
    void    OnIoCompletion(DWORD dwErrorCode, DWORD dwBytes);
    void    OnConnected();

	long    m_nArea;
	long    m_nCountry;
	long    m_nPhoneNo;
    CtLine  m_line;
    CtCall  m_call;
    UINT    m_nTimer;    
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TDAEMONDLG_H__1A21B6DA_5147_11D1_A84F_0080C7667ABF__INCLUDED_)
