// LinesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "tMonitor.h"
#include "LinesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinesDlg dialog


CLinesDlg::CLinesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLinesDlg::IDD, pParent), m_rgLines(0)
{
	//{{AFX_DATA_INIT(CLinesDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CLinesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLinesDlg)
	DDX_Control(pDX, IDC_LINES, m_listLines);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLinesDlg, CDialog)
	//{{AFX_MSG_MAP(CLinesDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLinesDlg message handlers

BOOL CLinesDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
    CRect   rect;
    m_listLines.GetClientRect(&rect);
    int     nWidth = rect.Width()/3;

    m_listLines.InsertColumn(0, "Line ID", LVCFMT_LEFT, nWidth);
    m_listLines.InsertColumn(1, "Line Name", LVCFMT_LEFT, nWidth);
    m_listLines.InsertColumn(2, "Monitor Status", LVCFMT_LEFT, nWidth);

    // Populate list of line info
    ASSERT(m_rgLines);

    CtLineDevCaps   ldc;
    DWORD           nLines = ::TfxGetNumLines();
    for( DWORD i = 0; i < nLines; i++ )
    {
        CString sID;
        sID.Format("%lu", i);
        m_listLines.InsertItem(i, sID);

        LPCSTR  pszName = 0;
        if( TSUCCEEDED(ldc.GetDevCaps(i)) )
        {
            pszName = ldc.GetLineName();
        }
        else
        {
            pszName = "<unknown>";
        }

        m_listLines.SetItemText(i, 1, pszName);
        m_listLines.SetItemText(i, 2, (m_rgLines[i].GetHandle() ? "Open" : "Not open"));
    }
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
