// tDialDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CtDialDlg dialog

class CtDialDlg : public CDialog,
                  public CtLineSink,
                  public CtCallSink
{
// Construction
public:
	CtDialDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CtDialDlg)
	enum { IDD = IDD_TDIAL_DIALOG };
	CButton	m_btnAnswer;
	CButton	m_btnHangUp;
	CListBox	m_listLines;
	CEdit	m_editLog;
	CButton	m_btnDial;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CtDialDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CtDialDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnAnswer();
	afx_msg void OnDial();
	afx_msg void OnHangUp();
	afx_msg void OnDestroy();
	afx_msg void OnAbout();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    // Handle CtLineSink event
    virtual void OnLineClose(CtLine* pLine);
    virtual void OnLineNewCall(CtLine* pLine, HCALL hCall, DWORD nAddressID, DWORD nCallPriviledge);


    // Handle CtCallSink events
    virtual void OnCallState(CtCall* pCall, DWORD nCallState, DWORD dwParam2, DWORD nCallPriviledge);
    virtual void OnCallReply(CtCall* pCall, TRESULT nRequestID, TREQUEST nResult, DWORD nRequestType);

private:
    CtLine**    m_rgpLines;
    CtCall*     m_pCall;
    BOOL        m_bCallUnanswered;
    BOOL*       m_rgbValidLines;

	void    Dial(LPCSTR pszPhoneNo = 0);
    void    OpenValidLines();
    void    LogStatus(LPCSTR pszFormat, ...);
	void    UpdateStatus();
    void    UpdateRequestRecipientStatus();
};
