// PhoneNoDlg.h : header file
//

#include "tPhoneNo.h"   // CtPhoneNo
#include "resource.h"

/////////////////////////////////////////////////////////////////////////////
// CPhoneNoDlg dialog

class CPhoneNoDlg : public CDialog
{
// Construction
public:
    // INPUT/OUTPUT
    CString     m_sDeviceClass; // in
    DWORD       m_nLines;       // in
    HLINEAPP    m_hLineApp;     // in
    DWORD*      m_aApiVersions; // in

	CtPhoneNo   m_pno;          // in/out
	DWORD       m_nLineID;      // in/out
    DWORD       m_nAddressID;   // in/out

    CString     m_sDialable;    // out

    // Array of size m_nLines of what lines should be shown
    const BOOL* m_rgbShouldShowLines;   // in

	CPhoneNoDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CPhoneNoDlg)
	enum { IDD = IDD_PHONE_NO };
	CComboBox	m_listAddresses;
	CButton	m_btnConfigDialog;
	CButton	m_btnTranslateDialog;
	CStatic	m_iconLine;
	CEdit	m_editAreaCode;
	CButton	m_btnOK;
	CComboBox	m_listLines;
	CComboBox	m_listLocations;
	CComboBox	m_listCountryCodes;
	CString	m_sAreaCode;
	BOOL	m_bBuildCanonical;
	CString	m_sDialString;
	CString	m_sPhoneNo;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPhoneNoDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CPhoneNoDlg)
	afx_msg void OnSelchangeLocations();
	virtual BOOL OnInitDialog();
	afx_msg void OnChangeAreaCode();
	afx_msg void OnChangeBuildCanonical();
	afx_msg void OnChangePhoneNo();
	afx_msg void OnSelchangeCountryCode();
	afx_msg void OnSelchangeLines();
	afx_msg void OnConfigDialog();
	afx_msg void OnTranslateDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void    UpdateControls();
    BOOL    ShouldShowLine(DWORD nLineID);
    void    ShowLineIcon();
    void    PopulateCountryCodes(DWORD nCountryCode);
    void    PopulateLocations();
    void    PopulateLines();
    void    PopulateAddresses();
};
