// CustoDial.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "CustoDial.h"
#include "CustoDialDlg.h"

#include <tapi.h>   // tapiRequestMakeCall() and tapiGetLocationInfo()

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCustoDialApp

BEGIN_MESSAGE_MAP(CCustoDialApp, CWinApp)
	//{{AFX_MSG_MAP(CCustoDialApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCustoDialApp construction

CCustoDialApp::CCustoDialApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCustoDialApp object

CCustoDialApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CCustoDialApp initialization

BOOL CCustoDialApp::InitInstance()
{
	// Standard initialization
	CCustoDialDlg dlg;
	m_pMainWnd = &dlg;

    // Initialize the dialog
    dlg.m_sName = "A. Nonymous";

    // Get default location info
    LONG    r;
    r = ::tapiGetLocationInfo(dlg.m_sCountryCode.GetBuffer(8),
                              dlg.m_sAreaCode.GetBuffer(8));
    dlg.m_sCountryCode.ReleaseBuffer();
    dlg.m_sAreaCode.ReleaseBuffer();

    if( r < 0 )
    {
        ::AfxMessageBox(IDS_NOLOCATIONINFO);
    }

    // Run the dialog
    if( dlg.DoModal() == IDOK )
    {
        // Init arguments to tapiRequestMakeCall()
        LPCSTR  szName = dlg.m_sName;
        LPCSTR  szAppName = ::AfxGetAppName();
        LPCSTR  szComment = dlg.m_sComment;

        // Try to make a canonical phone number
        CString sDestAddress;
        if( !dlg.m_sCountryCode.IsEmpty() &&
            !dlg.m_sPhoneNo.IsEmpty() )
        {
            if( !dlg.m_sAreaCode.IsEmpty() )
            {
                sDestAddress.Format("+%s (%s) %s", dlg.m_sCountryCode,
                                    dlg.m_sAreaCode, dlg.m_sPhoneNo);
            }
            else
            {
                sDestAddress.Format("+%s %s", dlg.m_sCountryCode,
                                    dlg.m_sPhoneNo);
            }
        }
        // Can't make it canonical easily, so let the request
        // recipient deal w/ what we've got.
        else
        {
            sDestAddress.Format("%s %s %s", dlg.m_sCountryCode,
                            dlg.m_sAreaCode, dlg.m_sPhoneNo);
        }

        // Remove the WM_QUIT message from the message queue
        // (Otherwise any error message boxes won't show).
        MSG msg;
        ::PeekMessage(&msg, 0, WM_QUIT, WM_QUIT, PM_REMOVE);

        // Dial the number
        r = ::tapiRequestMakeCall(sDestAddress, szAppName, szName, szComment);

        switch( r )
        {
        case TAPIERR_NOREQUESTRECIPIENT:
            ::AfxMessageBox(IDS_NOREQUESTRECIPIENT);
        break;

        case TAPIERR_REQUESTQUEUEFULL:
            ::AfxMessageBox(IDS_REQUESTQUEUEFULL);
        break;

        case TAPIERR_INVALDESTADDRESS:
            ::AfxMessageBox(IDS_INVALDESTADDRESS);
        break;

        case TAPIERR_INVALPOINTER:
            TRACE("TAPIERR_INVALPOINTER\n");
            ASSERT(FALSE);
        break;
        }
    }

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}
